local EngieTeleporter = Class(function(self, inst)
    self.inst = inst
    self.boundEntrance = nil
end)

function EngieTeleporter:CollectSceneActions(doer, actions, right)
	if right then
            table.insert(actions, ACTIONS.ENGIETELEPORT)
	end
end

local tp_sayings = {
	GENERIC = { "Thanks for the ride!", "I'm back!", "Thanks!", "Thanks.", "Woah, thanks for the ride!", "Thanks for the ride.", "Thanks for the trip!"},
	engineer = { "Much obliged, pardner!", "Thanks for the ride, pardner.", "Welp, back to work.", "Move on out.", "Gettin' things done.", "Now what'd I miss?", "All on me.", "Checkin' up over here.", "That'll do.", "That's that.", "Looks like it's workin' just fine.", "Yeehaw!", "The boys back home woulda 'preciated this.", "Nice work.", "Guess it's up to me now.", "Back again.", "Looks like I'm back here.", "Been brought back to these parts.", "Same as ever.", "Thing's are lookin' up.", "Back already?", "Bringin' it back home.", "Mother science provided that one.", "Teleportin' back.", "Giddy up.", "Howdy.", "Time to get back to work over here.", "Now that there was a fine piece of work.", "Well don't that beat all?", "Job well done.", "Good work." },
}

function EngieTeleporter:TeleportAction(doer)

    local char_accounce_table = tp_sayings[doer.prefab] or tp_sayings["GENERIC"]
    local say_index = math.floor(GetRandomMinMax(0,#char_accounce_table)) + 1
    if self.boundEntrance.pairedGUID == nil then
	doer.sg:GoToState("idle")
	doer.components.talker:Say("Somebody wanna rustle up a Teleporter Exit right here?")
    end
    if self.boundEntrance.pairedGUID then
	self.boundEntrance.paired:PushEvent("startfx")
	doer.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl3_run", "sound")
	doer.components.locomotor:StopMoving()
	doer.components.playercontroller:Enable(false)
	doer.components.health:SetInvincible(true)
        doer:DoTaskInTime(1.3, function()
	    doer.Physics:Teleport(self.boundEntrance.paired:GetPosition():Get())
	    if doer.components.leader ~= nil then
		for follower, v in pairs(doer.components.leader.followers) do
		    follower.Physics:Teleport(self.boundEntrance.paired:GetPosition():Get())
		end
	    end
	    if doer.components.inventory ~= nil then
		for k, item in pairs(doer.components.inventory.itemslots) do
		    if item.components.leader ~= nil then
			for follower, v in pairs(item.components.leader.followers) do
			    follower.Physics:Teleport(self.boundEntrance.paired:GetPosition():Get())
			end
		    end
		end
		-- special special case, look inside equipped containers
		for k, equipped in pairs(doer.components.inventory.equipslots) do
		    if equipped.components.container ~= nil then
			for j, item in pairs(equipped.components.container.slots) do
			    if item.components.leader ~= nil then
				for follower, v in pairs(item.components.leader.followers) do
				    follower.Physics:Teleport(self.boundEntrance.paired:GetPosition():Get())
				end
			    end
			end
		    end
		end
	    end
	    TheFrontEnd:Fade(true,1)
	    TheCamera:Snap()
	    doer.components.playercontroller:Enable(true)
	    doer.components.health:SetInvincible(false)
	    doer.sg:GoToState("idle")
	    doer.SoundEmitter:KillSound("sound")
	    self.boundEntrance.paired:PushEvent("endfx")
	    doer:DoTaskInTime(3*FRAMES, function()
		doer.components.talker:Say( char_accounce_table[say_index] )
		doer.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/lightninggoat/shocked_electric")
		local telefx = SpawnPrefab("eshockfx")
		telefx.Transform:SetScale(.80, 0.5, .80)
		telefx.entity:AddFollower()
		telefx.Follower:FollowSymbol(doer.GUID, "swap_body", 0, 0, 0)
	    end)
	end)
    end
end

return EngieTeleporter